/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChainMutator;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.ToBeanRowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Predicates;

public class EmbeddedClassMapping<C, T extends Table<T>>
implements EmbeddedBeanMapping<C, T> {
    private final Class<C> classToPersist;
    private final T targetTable;
    private final Map<ReversibleAccessor<C, ?>, Column<T, ?>> propertyToColumn;
    private final Map<ReversibleAccessor<C, ?>, Column<T, ?>> readonlyPropertyToColumn;
    private final Set<Column<T, Object>> columns;
    private final Map<Accessor<C, ?>, Column<T, ?>> insertableProperties;
    private final Map<Accessor<C, ?>, Column<T, ?>> updatableProperties;
    private final ToBeanRowTransformer<C> rowTransformer;
    private DefaultValueDeterminer defaultValueDeterminer = new DefaultValueDeterminer(){};
    private final KeepOrderSet<Mapping.ShadowColumnValueProvider<C, T>> shadowColumnsForInsert = new KeepOrderSet();
    private final KeepOrderSet<Mapping.ShadowColumnValueProvider<C, T>> shadowColumnsForUpdate = new KeepOrderSet();
    private final ValueAccessPointSet<C> propertiesSetByConstructor = new ValueAccessPointSet();
    private ValueAccessPointMap<C, Converter<Object, Object>> readConverters = new ValueAccessPointMap();
    private ValueAccessPointMap<C, Converter<Object, Object>> writeConverters = new ValueAccessPointMap();

    public EmbeddedClassMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> propertyToColumn) {
        this(classToPersist, targetTable, propertyToColumn, new HashMap(), null);
    }

    public EmbeddedClassMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> propertiesMapping, Map<? extends ReversibleAccessor<C, ?>, ? extends Column<T, ?>> readonlyPropertiesMapping, @javax.annotation.Nullable Function<ColumnedRow, C> beanFactory) {
        this.classToPersist = classToPersist;
        this.targetTable = targetTable;
        this.propertyToColumn = new KeepOrderMap(propertiesMapping);
        this.readonlyPropertyToColumn = new KeepOrderMap(readonlyPropertiesMapping);
        Map columnToField = Iterables.map(propertiesMapping.entrySet(), Map.Entry::getValue, e -> ((ReversibleAccessor)e.getKey()).toMutator(), KeepOrderMap::new);
        readonlyPropertiesMapping.forEach((accessor, column) -> columnToField.put(column, accessor.toMutator()));
        this.rowTransformer = new EmbeddedBeanRowTransformer((Function)Nullable.nullable(beanFactory).getOr(() -> row -> Reflections.newInstance((Class)classToPersist)), columnToField);
        this.columns = new KeepOrderSet(this.rowTransformer.getColumnToMember().keySet());
        this.insertableProperties = new KeepOrderMap();
        this.propertyToColumn.forEach((accessor, column) -> {
            if (!column.isAutoGenerated()) {
                this.insertableProperties.put((Accessor<C, ?>)accessor, (Column<T, ?>)column);
            }
        });
        this.updatableProperties = new KeepOrderMap();
        Set columnsWithoutPrimaryKey = ((Table)targetTable).getColumnsNoPrimaryKey();
        this.propertyToColumn.forEach((accessor, column) -> {
            if (columnsWithoutPrimaryKey.contains(column)) {
                this.updatableProperties.put((Accessor<C, ?>)accessor, (Column<T, ?>)column);
            }
        });
    }

    public Class<C> getClassToPersist() {
        return this.classToPersist;
    }

    public T getTargetTable() {
        return this.targetTable;
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getPropertyToColumn() {
        return Collections.unmodifiableMap(this.propertyToColumn);
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getReadonlyPropertyToColumn() {
        return Collections.unmodifiableMap(this.readonlyPropertyToColumn);
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
        return this.readConverters;
    }

    public void setReadConverters(ValueAccessPointMap<C, ? extends Converter<Object, Object>> converters) {
        this.readConverters = converters;
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
        return this.writeConverters;
    }

    public void setWriteConverters(ValueAccessPointMap<C, ? extends Converter<Object, Object>> writeConverters) {
        this.writeConverters = writeConverters;
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    public Set<Column<T, ?>> getInsertableColumns() {
        return Collections.unmodifiableSet(new KeepOrderSet(this.insertableProperties.values()));
    }

    public Set<Column<T, ?>> getUpdatableColumns() {
        return Collections.unmodifiableSet(new KeepOrderSet(this.updatableProperties.values()));
    }

    @Override
    public RowTransformer<C> getRowTransformer() {
        return this.rowTransformer;
    }

    public void setDefaultValueDeterminer(DefaultValueDeterminer defaultValueDeterminer) {
        this.defaultValueDeterminer = defaultValueDeterminer;
    }

    @Override
    public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.shadowColumnsForInsert.add(valueProvider);
    }

    @Override
    public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.shadowColumnsForUpdate.add(valueProvider);
    }

    @Override
    public <O> void addShadowColumnSelect(Column<T, O> column) {
        this.columns.add(column);
    }

    Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForInsert() {
        return Collections.unmodifiableCollection(this.shadowColumnsForInsert);
    }

    Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForUpdate() {
        return Collections.unmodifiableCollection(this.shadowColumnsForUpdate);
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<C> accessor) {
        this.propertiesSetByConstructor.add(accessor);
    }

    @Override
    public Map<Column<T, ?>, Object> getInsertValues(C c) {
        KeepOrderMap result = new KeepOrderMap();
        this.insertableProperties.forEach((arg_0, arg_1) -> this.lambda$getInsertValues$6(c, (Map)result, arg_0, arg_1));
        this.shadowColumnsForInsert.forEach(arg_0 -> EmbeddedClassMapping.lambda$getInsertValues$7(c, (Map)result, arg_0));
        return result;
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, Object> getUpdateValues(C modified, C unmodified, boolean allColumns) {
        KeepOrderMap unmodifiedColumns = new KeepOrderMap();
        KeepOrderMap modifiedFields = new KeepOrderMap();
        this.updatableProperties.forEach((arg_0, arg_1) -> this.lambda$getUpdateValues$8(modified, unmodified, (Map)modifiedFields, (Map)unmodifiedColumns, arg_0, arg_1));
        this.shadowColumnsForUpdate.forEach(arg_0 -> EmbeddedClassMapping.lambda$getUpdateValues$12(modified, unmodified, (Map)modifiedFields, (Map)unmodifiedColumns, arg_0));
        if (!modifiedFields.isEmpty() && allColumns) {
            for (Map.Entry unmodifiedField : unmodifiedColumns.entrySet()) {
                modifiedFields.put(new Mapping.UpwhereColumn((Column)unmodifiedField.getKey(), true), unmodifiedField.getValue());
            }
        }
        return modifiedFields;
    }

    @Override
    public C transform(ColumnedRow row) {
        return this.rowTransformer.transform(row);
    }

    private static /* synthetic */ void lambda$getUpdateValues$12(Object modified, Object unmodified, Map modifiedFields, Map unmodifiedColumns, Mapping.ShadowColumnValueProvider shadowColumnValueProvider) {
        if (shadowColumnValueProvider.accept(modified)) {
            if (modified != null && unmodified == null) {
                Map modifiedValues = shadowColumnValueProvider.giveValue(modified);
                modifiedValues.forEach((col, value) -> modifiedFields.put(new Mapping.UpwhereColumn(col, true), value));
            } else if (modified == null && unmodified != null) {
                Set<Column<Column, ?>> shadowColumns = shadowColumnValueProvider.getColumns();
                shadowColumns.forEach(col -> modifiedFields.put(new Mapping.UpwhereColumn(col, true), null));
            } else if (modified != null && unmodified != null) {
                Map modifiedValues = shadowColumnValueProvider.giveValue(modified);
                Map unmodifiedValues = shadowColumnValueProvider.giveValue(unmodified);
                Set<Column<Column, ?>> shadowColumns = shadowColumnValueProvider.getColumns();
                shadowColumns.forEach(col -> {
                    Object modifiedValue = modifiedValues.get(col);
                    if (!Predicates.equalOrNull(modifiedValue, unmodifiedValues.get(col))) {
                        modifiedFields.put(new Mapping.UpwhereColumn(col, true), modifiedValue);
                    } else {
                        unmodifiedColumns.put(col, modifiedValue);
                    }
                });
            }
        }
    }

    private /* synthetic */ void lambda$getUpdateValues$8(Object modified, Object unmodified, Map modifiedFields, Map unmodifiedColumns, Accessor accessor, Column column) {
        Object unmodifiedValue;
        Object modifiedValue = accessor.get(modified);
        Converter converter = (Converter)this.writeConverters.get((Object)accessor);
        if (converter != null) {
            modifiedValue = converter.convert(modifiedValue);
        }
        Object object = unmodifiedValue = unmodified == null ? null : accessor.get(unmodified);
        if (!Predicates.equalOrNull((Object)modifiedValue, (Object)unmodifiedValue) || unmodified == null) {
            modifiedFields.put(new Mapping.UpwhereColumn(column, true), modifiedValue);
        } else {
            unmodifiedColumns.put(column, modifiedValue);
        }
    }

    private static /* synthetic */ void lambda$getInsertValues$7(Object c, Map result, Mapping.ShadowColumnValueProvider shadowColumnValueProvider) {
        if (shadowColumnValueProvider.accept(c)) {
            result.putAll(shadowColumnValueProvider.giveValue(c));
        }
    }

    private /* synthetic */ void lambda$getInsertValues$6(Object c, Map result, Accessor accessor, Column column) {
        Object value = accessor.get(c);
        Converter converter = (Converter)this.writeConverters.get((Object)accessor);
        if (converter != null) {
            value = converter.convert(value);
        }
        result.put(column, value);
    }

    public static interface DefaultValueDeterminer {
        default public boolean isDefaultValue(Duo<Column, Mutator> mappedProperty, Object value) {
            Class inputType = Accessors.giveInputType((Mutator)((Mutator)mappedProperty.getRight()));
            return !inputType.isPrimitive() && value == null || inputType.isPrimitive() && Reflections.PRIMITIVE_DEFAULT_VALUES.get(inputType) == value;
        }
    }

    private class EmbeddedBeanRowTransformer
    extends ToBeanRowTransformer<C> {
        public EmbeddedBeanRowTransformer(Function<? extends ColumnedRow, C> beanFactory, Map<? extends Column<?, ?>, ? extends Mutator<C, Object>> columnToMember) {
            super(beanFactory, columnToMember);
        }

        @Override
        public void applyRowToBean(ColumnedRow values, C targetRowBean) {
            HashMap<Map.Entry, Object> beanValues = new HashMap<Map.Entry, Object>();
            HashMap<Accessor, MutableBoolean> valuesAreDefaultOnes = new HashMap<Accessor, MutableBoolean>();
            for (Map.Entry columnFieldEntry : this.getColumnToMember().entrySet()) {
                Object propertyValue = values.get((Selectable)columnFieldEntry.getKey());
                Converter converter = (Converter)EmbeddedClassMapping.this.readConverters.get(columnFieldEntry.getValue());
                if (converter != null) {
                    propertyValue = converter.convert(propertyValue);
                }
                beanValues.put(columnFieldEntry, propertyValue);
                if (!(columnFieldEntry.getValue() instanceof AccessorChainMutator)) continue;
                Accessor valuesAreDefaultOnesKey = (Accessor)((AccessorChainMutator)columnFieldEntry.getValue()).getAccessors().get(0);
                MutableBoolean mutableBoolean = valuesAreDefaultOnes.computeIfAbsent(valuesAreDefaultOnesKey, k -> new MutableBoolean(true));
                boolean valueIsDefault = EmbeddedClassMapping.this.defaultValueDeterminer.isDefaultValue((Duo<Column, Mutator>)new Duo(columnFieldEntry.getKey(), columnFieldEntry.getValue()), propertyValue);
                mutableBoolean.and(valueIsDefault);
            }
            beanValues.forEach((mapping, value) -> {
                if (mapping.getValue() instanceof AccessorChainMutator) {
                    Accessor valuesAreDefaultOnesKey = (Accessor)((AccessorChainMutator)mapping.getValue()).getAccessors().get(0);
                    boolean valueIsDefault = ((MutableBoolean)valuesAreDefaultOnes.get(valuesAreDefaultOnesKey)).value();
                    if (!valueIsDefault) {
                        this.applyValueToBean(targetRowBean, (Map.Entry)mapping, value);
                    }
                } else {
                    this.applyValueToBean(targetRowBean, (Map.Entry)mapping, value);
                }
            });
        }

        @Override
        protected void applyValueToBean(C targetRowBean, Map.Entry<? extends Column, ? extends Mutator<C, Object>> columnFieldEntry, Object propertyValue) {
            if (!EmbeddedClassMapping.this.propertiesSetByConstructor.contains(columnFieldEntry.getValue())) {
                super.applyValueToBean(targetRowBean, columnFieldEntry, propertyValue);
            }
        }

        private class MutableBoolean {
            private boolean value;

            private MutableBoolean(boolean value) {
                this.value = value;
            }

            public boolean value() {
                return this.value;
            }

            public void and(boolean otherValue) {
                this.value &= otherValue;
            }
        }
    }
}

